;***********************************
;** MAP PROGRAM FOR RIVER PROJECT **
;***********************************

SCR=$F8000
MAPHEIGHT=200
MAPWIDTH=7
 BRA START
 DC.B 'Palette registers:'
 ALIGN.W
PAL:
 DC.W $000,$333,$555,$777,$020,$030,$040,$060
 DC.W $770,$740,$700,$200,$320,$750,$125,$237
 DC.B 'Grafix file to load:'
GRAFFILE:
 DC.B 'BLOCKGX.DAT ',0
 DC.B '     Map file to load/save:'
MAPFILE:
 DC.B 'LEVEL1.MAP',0
 ALIGN.W
BUFF:
 DS.B 3000,0

START:
 CLR.L -(SP)     ;SV MODE
 MOVE.W #$20,-(SP)
 TRAP #1
 ADDQ.L #6,SP
 MOVE.L D0,SPAR+4

 CLR.B $484      ;KEYCLICK
 BSR LOADFILES

 PEA MOUSE
 MOVE.W #1,-(SP)
 MOVE.W #25,-(SP)
 TRAP #14
 ADDQ.L #8,SP

 CLR.W -(SP)     ;SETSCR
 PEA SCR
 PEA SCR
 MOVE.W #5,-(SP)
 TRAP #14
 ADD.L #12,SP

 LEA $FF8240,A0
 LEA OPAL,A1
 MOVEQ #7,D0
 BSR COPY
 LEA PAL,A0
 LEA $FF8240,A1
 MOVEQ #7,D0
 BSR COPY

 LEA SCR-$8000,A0
 MOVE.W #15999,D0
CLS:
 CLR.L (A0)+
 DBRA D0,CLS

 LEA MESSAGE1,A0
 BSR MESSAGE
 MOVE.L #SCR-$8000,$44E
 LEA MESSAGE1,A0
 BSR MESSAGE

 MOVE.W #$2700,SR
 MOVE.L $70,OVBL
 MOVE.L #VBL,$70
 MOVE.W #$2300,SR

DEADLOP:
 CMP.B #$66,$FFFC02
 BNE DEADLOP

EXIT:
 MOVE.W #$2700,SR
 MOVE.L OVBL,$70
 MOVE.W #$2300,SR

 MOVE.W #1,-(SP)
 PEA SCR
 PEA SCR
 MOVE.W #5,-(SP)
 TRAP #14
 ADD.L #12,SP

 LEA OPAL,A0
 LEA $FF8240,A1
 MOVEQ #7,D0
 BSR COPY

 MOVE.L SPAR+4,-(SP)
 MOVE.W #$20,-(SP)
 TRAP #1
 ADDQ.L #6,SP

 PEA MOUSE+2
 MOVE.W #1,-(SP)
 MOVE.W #25,-(SP)
 TRAP #14
 ADDQ.L #8,SP
 ILLEGAL
MESSAGE:
 MOVE.L A0,-(SP)
 MOVE.W #9,-(SP)
 TRAP #1
 ADDQ.L #6,SP
 RTS
COPY:
 MOVE.L (A0)+,(A1)+
 DBRA D0,COPY
 RTS

VBL:
 MOVE.W #$2700,SR
 MOVE.W #$000,$FF8240
 BTST #0,CLOCK+1
 BNE NOTNOW

 ADD.B #$80,SCREEN+2
 MOVE.L SCREEN,A6

 BSR UPDAT
 BSR KEYPROCESS

 MOVE.B SCREEN+1,$FF8201
 MOVE.B SCREEN+2,$FF8203
NOTNOW:
 ADDQ.W #1,CLOCK
 MOVE.W #$111,$FF8240
 MOVE.W #$2300,SR
 RTE


;***********************************
;** PROCESS KEYPRESS              **
;***********************************
KEYWAIT:
 DC.B 2,0
KEYPROCESS:
 SUBQ.B #1,KEYWAIT
 BNE NOSTYR
 MOVE.B #2,KEYWAIT
 MOVE.B $FFFC02,D0
 CMP.B #$48,D0
 BEQ UP
 CMP.B #$50,D0
 BEQ DOWN
 CMP.B #$4B,D0
 BEQ LEFT
 CMP.B #$4D,D0
 BEQ RIGHT
 CMP.B #$39,D0
 BEQ SPACE
 CMP.B #$1E,D0  ;A
 BEQ MINUS
 CMP.B #$2C,D0  ;Z
 BEQ PLUS
 CMP.B #$0E,D0
 BEQ BACKSPACE
 CMP.B #$21,D0  ;F
 BEQ FILL
 CMP.B #$3F,D0  ;F5
 BEQ SAVE
NOSTYR:
 RTS
SAVE:
 MOVE.W #0,-(SP)
 PEA MAPFILE
 MOVE.W #$3C,-(SP)
 TRAP #1
 ADDQ.L #8,SP
 TST.L D0
 BMI ERROR
 MOVE.W D0,D7

 PEA BLOCKS
 PEA MAPHEIGHT*MAPWIDTH
 MOVE.W D7,-(SP)
 MOVE.W #$40,-(SP)
 TRAP #1
 ADD.L #12,SP
 TST.L D0
 BMI ERROR

 BSR CLOSE
 RTS
ERROR:
 ADDQ.W #1,$FF8240
 CMP.B #$39,$FFFC02
 BNE ERROR
 RTS
PLUS:
 CMP.L #BLOCKGX+(255*512),CHOICES+2
 BEQ NOSTYR
 ADD.L #512,CHOICES+2
 ADDQ.B #1,CURBLOCK
 RTS
MINUS:
 CMP.L #BLOCKGX,CHOICES+2
 BEQ NOSTYR
 SUB.L #512,CHOICES+2
 SUBQ.B #1,CURBLOCK
 RTS
SPACE:
 MOVE.L UPDAT+2,A0
 SUB.W #3*MAPWIDTH,A0
 CMP.L #BLOCKS,A0
 BLO NOSTYR
 ADD.W CURSX,A0
 MOVE.B CURBLOCK,(A0)
 RTS
FILL:
 MOVE.L UPDAT+2,A0
 SUB.W #3*MAPWIDTH,A0
 CMP.L #BLOCKS,A0
 BLO NOSTYR
 MOVEQ #MAPWIDTH-1,D0
FI1:
 MOVE.B CURBLOCK,(A0)+
 DBRA D0,FI1
 RTS
BACKSPACE:
 MOVE.L #BLOCKGX,CHOICES+2
 CLR.B CURBLOCK
 RTS
UP:
 MOVE.L UPDAT+2,A0
 CMP.L #BLOCKSLUT+(MAPWIDTH*2),A0
 BEQ NOSTYR
 ADDQ.L #MAPWIDTH,A0
 MOVE.L A0,UPDAT+2
 ADDQ.W #1,POS
 RTS
DOWN:
 MOVE.L UPDAT+2,A0
 CMP.L #BLOCKS+(MAPWIDTH*3),A0
 BEQ NOSTYR
 SUBQ.L #MAPWIDTH,A0
 MOVE.L A0,UPDAT+2
 SUBQ.W #1,POS
 RTS
LEFT:
 MOVE.W CURSX,D0
 BEQ NOSTYR
 SUBQ.W #1,D0
 MOVE.W D0,CURSX
 RTS
RIGHT:
 MOVE.W CURSX,D0
 CMP.B #5,D0
 BEQ NOSTYR
 ADDQ.W #1,D0
 MOVE.W D0,CURSX
 RTS
;***********************************
;** END OF KEYBOARD ROUTINE       **


;***********************************
;** UPDATE SCREEN                 **
;***********************************
UPDAT:      ;PEK!
 LEA BLOCKS+21,A2
 MOVE.L A6,A1
 MOVEQ #5,D5
UP2:
 MOVEQ #5,D4
UP1:
 CLR.L D0
 MOVE.B (A2)+,D0
 LSL.L #8,D0
 LSL.L #1,D0
 LEA BLOCKGX,A0
 ADD.L D0,A0
L@=0
N@=0
 REPEAT
  MOVEM.L (A0)+,D0-D3
  MOVEM.L D0-D3,L@(A1)
L@=L@+160
N@=N@+1
 UNTILEQ N@,32
 ADD.W #16,A1
 DBRA D4,UP1
 SUB.W #(MAPWIDTH*2)-1,A2
 ADD.W #5024,A1   ;32*160 - 6*16
 DBRA D5,UP2
 BSR CURSOR
 BSR CHOICES
 BSR WRITEPOS
 RTS



CURSOR:           ;DRAW CURSOR
 MOVE.L A6,A1
 ADD.W #96*160,A1
 MOVE.W CURSX,D0
 LSL.W #4,D0
 ADD.W D0,A1
CURSUB:
 MOVEQ #-1,D1
 MOVEQ #0,D2
 MOVEQ #1,D0
CURS1:
 MOVE.L D2,(A1)
 MOVE.W D2,4(A1)
 MOVE.W D1,6(A1)

 MOVE.L D2,8(A1)
 MOVE.W D2,12(A1)
 MOVE.W D1,14(A1)
 ADD.W #160,A1
 DBRA D0,CURS1

 MOVE.W #%0011111111111111,D1
 MOVE.W #%1100000000000000,D2
 MOVE.W #%1111111111111100,D3
 MOVE.W #%0000000000000011,D4

 MOVEQ #27,D0
CURS2:
 AND.W D1,(A1)
 AND.W D1,2(A1)
 AND.W D1,4(A1)
 OR.W D2,6(A1)

 AND.W D3,8(A1)
 AND.W D3,10(A1)
 AND.W D3,12(A1)
 OR.W D4,14(A1)
 ADD.W #160,A1
 DBRA D0,CURS2

 MOVEQ #0,D2
 MOVEQ #-1,D1
 MOVEQ #1,D0
CURS3:
 MOVE.L D2,(A1)
 MOVE.W D2,4(A1)
 MOVE.W D1,6(A1)

 MOVE.L D2,8(A1)
 MOVE.W D2,12(A1)
 MOVE.W D1,14(A1)
 ADD.W #160,A1
 DBRA D0,CURS3

 RTS


CHOICES:   ;PEK!
 LEA BLOCKGX,A0
 MOVE.L A6,A1
 ADD.W #144,A1
 MOVE.W #160,D4
 MOVE.W #(6*32)-1,D5
CH1:
 MOVEM.L (A0)+,D0-D3
 MOVEM.L D0-D3,(A1)
 ADD.W D4,A1
 DBRA D5,CH1
 MOVE.L A6,A1
 ADD.W #144,A1
 BSR CURSUB
 RTS

WRITEPOS:
 MOVEQ #0,D0
 MOVE.W POS,D0
 MOVE.L SCREEN,$44E
 BSR DCIP
 RTS

DCIP:          ;WRITE A DECIMAL NR IN D0
 LEA TBUF,A0
 MOVE.L #'    ',D1
 MOVE.B #27,(A0)+
 MOVE.B #'Y',(A0)+
 MOVE.B #53,(A0)+
 MOVE.B #60,(A0)+
 MOVE.L D1,(A0)+
 MOVE.L D1,(A0)+
DCI1:
 CMP.L #10,D0
 BLO DCI2
 DIVU #10,D0
 SWAP D0
 ADD.W #$30,D0
 MOVE.B D0,-(A0)
 CLR.W D0
 SWAP D0
 BRA DCI1
DCI2:
 ADD.W #$30,D0
 MOVE.B D0,-(A0)
 LEA TBUF,A0
 BSR MESSAGE
 RTS
TBUF:
 DS.B 20,0
;***********************************
;** END OF SCREEN UPDATE          **


;***********************************
;** LOAD FILES                    **
;***********************************
LOADFILES:
 CLR.W -(SP)    ;LOAD BLOCK GX
 PEA GRAFFILE
 MOVE.W #$3D,-(SP)
 TRAP #1
 ADDQ.L #8,SP
 MOVE.W D0,D7

 PEA BLOCKGX+512
 PEA 255*512
 MOVE.W D7,-(SP)
 MOVE.W #$3F,-(SP)
 TRAP #1
 ADD.L #12,SP

 BSR CLOSE

 MOVE.W #0,-(SP)  ;LOAD BLOCK MAP
 PEA MAPFILE
 MOVE.W #$3D,-(SP)
 TRAP #1
 ADDQ.L #8,SP
 MOVE.W D0,D7

 PEA BLOCKS
 PEA MAPHEIGHT*MAPWIDTH
 MOVE.W D7,-(SP)
 MOVE.W #$3F,-(SP)
 TRAP #1
 ADD.L #12,SP

 BSR CLOSE
 RTS

CLOSE:
 MOVE.W D7,-(SP)
 MOVE.W #$3E,-(SP)
 TRAP #1
 ADDQ.L #4,SP
 RTS
;***********************************
;** END OF LOAD FILES             **


SPAR: DS.L 8,0
SPAR1: DC.L 0
SPAR2: DC.L 0
SPAR3: DC.L 0
SPAR4: DC.L 0
SPAR5: DC.W 0
OPAL:
 DS.W 16,0
OVBL:
 DC.L 0

MESSAGE1:
 DC.B 27,'Y',32,56,27,'b',8,'    MEGA'
 DC.B 27,'Y',33,56,'   MAPPER'
 DC.B 27,'Y',34,56,'    V1.0'
 DC.B 27,'Y',36,56,' By STalin.'
 DC.B 27,'Y',38,56,'    For'
 DC.B 27,'Y',39,56,'Earthlights'
 DC.B 27,'Y',40,56,'eyes only..!'
 DC.B 27,'Y',42,56,'Controls:'
 DC.B 27,'Y',43,56,'A=Block -'
 DC.B 27,'Y',44,56,'Z=Block +'
 DC.B 27,'Y',45,56,'SPCE=Place'
 DC.B 27,'Y',46,56,'BACK=Blk 0'
 DC.B 27,'Y',47,56,'F5=Save'
 DC.B 27,'Y',48,56,'F=Fill line'
 DC.B 27,'Y',50,56,'Arrow keys'
 DC.B 27,'Y',51,56,'move cursor.'
 DC.B 27,'Y',53,56,'Pos:'
 DC.B 0
 ALIGN.W


MOUSE:
 DC.B $12,$16,$14,8

CURSX:
 DC.W 2
CURBLOCK:
 DC.W 0

POS:
 DC.W 0

SCREEN:
 DC.L SCR

CLOCK:
 DC.W 0

 DS.B MAPWIDTH*6,0
BLOCKS:
 DS.B MAPHEIGHT*MAPWIDTH,0
BLOCKSLUT:
 DS.W 21,0
 ALIGN.W

BLOCKGX:
 DS.B 512,0

ENDLABEL:
TEMP EQU ENDLABEL+20000
 END

 